var searchResultProvider = new SearchResultsProvider("DXF", "DXF Reference");
searchResultProvider.setTopicInfoList(["",{"title":"DXF Format",
"href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5f35.htm",
"description":"The DXF™ format is a tagged data representation of all the information contained in an AutoCAD® drawing file. Tagged data means that each data element in the file is preceded by an integer number that is called a group code. A group code\'s value indicates what type of data element follows. This value also indicates the meaning of a data element for a given object (or record) type. Virtually all user-specified information in a drawing file can be represented in DXF format.",
"ancestors":[]},
{"title":"Organization of This Reference",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a6a.htm",
"description":"The DXF Reference presents the DXF™ group codes found in DXF files and encountered by AutoLISP® and ObjectARX® applications. This chapter describes the general DXF conventions. The remaining chapters list the group codes organized by object type. The group codes are presented in the order in which they are found in a DXF file, and each chapter is named according to the associated section of a DXF file. Although the DXF file format is used as the organizing mechanism for this reference, specific information on the actual formatting of DXF files is found in Advanced concepts relating to DXF group codes as they pertain to both applications and DXF files are found in",
"ancestors":[{"title": "DXF Format","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5f35.htm"}]},
{"title":"Revisions to the DXF Reference",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a69.htm",
"description":"This topic lists revisions since the last update of the DXF Reference. The version number of this DXF Reference is u19.1.01.",
"ancestors":[{"title": "DXF Format","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5f35.htm"}]},
{"title":"Formatting Conventions in This Reference",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a67.htm",
"description":"Each group code listed in this reference is presented by a numeric group code value and a description. All group codes can apply to DXF™ files, applications (AutoLISP or ObjectARX), or both. When the description of a code is different for applications and DXF files (or applies to only one or the other), the description is preceded by the following indicators:",
"ancestors":[{"title": "DXF Format","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5f35.htm"}]},
{"title":"Object and Entity Codes",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a65.htm",
"description":"In the DXF™ format, the definition of objects differs from entities: objects have no graphical representation and entities do. For example, dictionaries are objects, and not entities. Entities are also referred to as graphical objects while objects are referred to as nongraphical objects.",
"ancestors":[{"title": "DXF Format","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5f35.htm"}]},
{"title":"Group Code Value Types",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a64.htm",
"description":"Group codes define the type of the associated value as an integer, a floating-point number, or a string, according to the following table of group code ranges. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "DXF Format","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5f35.htm"}]},
{"title":"Group Codes in Numerical Order",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a62.htm",
"description":"The following table gives the group code or group code range accompanied by an explanation of the group code value. In the table, “fixed” indicates that the group code always has the same purpose. If a group code isn\'t fixed, its purpose depends on the context. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "DXF Format","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5f35.htm"}]},
{"title":"HEADER Section",
"href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5f05.htm",
"description":"The group codes described in this chapter pertain only to DXF™ files. The HEADER section of a DXF file contains the settings of variables associated with the drawing. Each variable is specified by a 9 group code giving the variable\'s name, followed by groups that supply the variable\'s value. This chapter lists only the variables that are saved in the drawing file.",
"ancestors":[]},
{"title":"HEADER Section Group Codes",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a6f.htm",
"description":"The following table lists the variables that are represented in the HEADER section of a DXF™ file. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "HEADER Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5f05.htm"}]},
{"title":"Revised VPORT Header Variables",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a6d.htm",
"description":"The following header variables existed before AutoCAD® Release 11 but now have independent settings for each active viewport. OPEN honors these variables when read from DXF™ files. If a VPORT symbol table with *ACTIVE entries is present (as is true for any DXF file produced by Release 11 or later), the values in the VPORT table entries override the values of these header variables.",
"ancestors":[{"title": "HEADER Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5f05.htm"},{"title": "HEADER Section Group Codes","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a6f.htm"}]},
{"title":"Special Handling of Date/Time Variables",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a6b.htm",
"description":"The CDATE and DATE system variables provide access to the current date and time. The TDCREATE, TDINDWG, TDUPDATE, and TDUSRTIMER system variables (and the $TDCREATE, $TDUCREATE, $TDUPDATE, and $TDUUPDATE DXF header variables) provide access to times and dates associated with the current drawing. The values are represented as real numbers with special meanings, as described below.",
"ancestors":[{"title": "HEADER Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5f05.htm"},{"title": "HEADER Section Group Codes","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a6f.htm"}]},
{"title":"CLASSES Section",
"href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e21.htm",
"description":"The group codes described in this chapter are found only in DXF™ files. The CLASSES section holds the information for application-defined classes whose instances appear in the BLOCKS, ENTITIES, and OBJECTS sections of the database. It is assumed that a class definition is permanently fixed in the class hierarchy. All fields are required.",
"ancestors":[]},
{"title":"CLASSES Section Group Codes",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a60.htm",
"description":"Each entry in the CLASSES section contains the groups described in the following table.",
"ancestors":[{"title": "CLASSES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e21.htm"}]},
{"title":"Default Class Values",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a5e.htm",
"description":"AutoCAD® registers the classes listed in the following table. (This may not be a complete list of the classes found in a DXF file. It depends on the applications currently in use by AutoCAD.)",
"ancestors":[{"title": "CLASSES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e21.htm"},{"title": "CLASSES Section Group Codes","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a60.htm"}]},
{"title":"TABLES Section",
"href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e1a.htm",
"description":"The group codes described in this chapter are found in DXF™ files and used by applications. The TABLES section contains several tables, each of which can contain a variable number of entries. These codes are also used by AutoLISP® and ObjectARX® applications in entity definition lists.",
"ancestors":[]},
{"title":"Symbol Table Group Codes",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a5c.htm",
"description":"The order of the tables may change, but the LTYPE table always precedes the LAYER table. Each table is introduced with a 0 group code with the label TABLE. This is followed by a 2 group code identifying the particular table (APPID, DIMSTYLE, LAYER, LTYPE, STYLE, UCS, VIEW, VPORT, or BLOCK_RECORD), a 5 group code (a handle), a 100 group code (AcDbSymbolTable subclass marker), and a 70 group code that specifies the maximum number of table entries that may follow. Table names are output in uppercase. The DIMSTYLE handle is a 105 group code, and not a 5 group code.",
"ancestors":[{"title": "TABLES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e1a.htm"}]},
{"title":"Common Symbol Table Group Codes",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a5b.htm",
"description":"The following table shows group codes that apply to all symbol tables. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "TABLES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e1a.htm"}]},
{"title":"Common Group Codes for Symbol Table Entries",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a59.htm",
"description":"The following table shows group codes that apply to all symbol table entries. When you refer to the table of group codes by entity type, which lists the codes associated with specific entities, keep in mind that the codes shown here can also be present. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "TABLES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e1a.htm"},{"title": "Common Symbol Table Group Codes","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a5b.htm"}]},
{"title":"APPID",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a57.htm",
"description":"The following group codes apply to APPID symbol table entries. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "TABLES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e1a.htm"}]},
{"title":"BLOCK_RECORD",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a55.htm",
"description":"The following group codes apply to BLOCK_RECORD symbol table entries. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "TABLES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e1a.htm"}]},
{"title":"DIMSTYLE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a53.htm",
"description":"The following group codes apply to DIMSTYLE symbol table entries. The DIMSTYLE system variables are described in “System Variables,” in the Command Reference. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "TABLES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e1a.htm"}]},
{"title":"LAYER",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a51.htm",
"description":"The following group codes apply to LAYER symbol table entries. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "TABLES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e1a.htm"}]},
{"title":"LTYPE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a4f.htm",
"description":"The following group codes apply to LTYPE symbol table entries. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "TABLES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e1a.htm"}]},
{"title":"STYLE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a4d.htm",
"description":"The following group codes apply to STYLE symbol table entries. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "TABLES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e1a.htm"}]},
{"title":"UCS",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a4b.htm",
"description":"The following group codes apply to UCS symbol table entries. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "TABLES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e1a.htm"}]},
{"title":"VIEW",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a49.htm",
"description":"The following group codes apply to VIEW symbol table entries. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "TABLES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e1a.htm"}]},
{"title":"VPORT",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a46.htm",
"description":"The following group codes apply to VPORT symbol table entries. The VPORT table is unique: it may contain several entries with the same name (indicating a multiple-viewport configuration). The entries corresponding to the active viewport configuration all have the name *ACTIVE. The first such entry describes the current viewport. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "TABLES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e1a.htm"}]},
{"title":"BLOCKS Section",
"href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e01.htm",
"description":"The group codes described in this chapter are found in DXF™ files and used by applications. The BLOCKS section contains an entry for each block reference in the drawing.",
"ancestors":[]},
{"title":"BLOCKS Section Group Codes",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a44.htm",
"description":"The BLOCKS section of the DXF file contains all the block definitions, including anonymous blocks generated by the HATCH command and by associative dimensioning. Each block definition contains the entities that make up that block as it is used in the drawing. The format of the entities in this section is identical to those in the ENTITIES section. All entities in the BLOCKS section appear between block and endblk entities. Block and endblk entities appear only in the BLOCKS section. Block definitions are never nested (that is, no block or endblk entity ever appears within another block-endblk pair), although a block definition can contain an insert entity.",
"ancestors":[{"title": "BLOCKS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e01.htm"}]},
{"title":"BLOCK",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a43.htm",
"description":"The following group codes apply to block entities. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "BLOCKS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e01.htm"}]},
{"title":"ENDBLK",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a3f.htm",
"description":"The following group codes apply to endblk objects. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "BLOCKS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5e01.htm"}]},
{"title":"ENTITIES Section",
"href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm",
"description":"This chapter presents the group codes that apply to graphical objects. These codes are found in the ENTITIES section of a DXF™ file and are used by AutoLISP® and ObjectARX® applications in entity definition lists.",
"ancestors":[]},
{"title":"Common Group Codes for Entities",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a3d.htm",
"description":"The following table shows group codes that apply to virtually all graphical objects. Some of the group codes shown here are included with an entity definition only if the entity has nondefault values for the property. When you refer to the group codes by entity type, the lists of codes associated with specific entities, keep in mind that the codes shown here are also present.",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"3DFACE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a3b.htm",
"description":"The following group codes apply to 3dface entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"3DSOLID",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a39.htm",
"description":"The following group codes apply to 3dsolid entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"ACAD_PROXY_ENTITY",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a37.htm",
"description":"The following group codes apply to proxy entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"ARC",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a35.htm",
"description":"The following group codes apply to arc entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"ATTDEF",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a33.htm",
"description":"The following group codes apply to attdef (attribute definition) entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"ATTRIB",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a31.htm",
"description":"The following group codes apply to attrib (attribute) entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"BODY",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a2f.htm",
"description":"The following group codes apply to body entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"CIRCLE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a2d.htm",
"description":"The following group codes apply to circle entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"DIMENSION",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a2b.htm",
"description":"Dimension entity definitions consist of group codes that are common to all dimension types, followed by codes specific to the type.",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"Common Dimension Group Codes",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a2a.htm",
"description":"The following group codes apply to all dimension entity types. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "DIMENSION","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a2b.htm"}]},
{"title":"Aligned Dimension Group Codes",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a26.htm",
"description":"The following group codes apply to aligned dimensions. In addition to the group codes described here, those listed in and can also be present. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "DIMENSION","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a2b.htm"}]},
{"title":"Linear and Rotated Dimension Group Codes",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a23.htm",
"description":"The following group codes apply to linear and rotated dimensions (note that linear and rotated dimensions are part of the AcDbAlignedDimension subclass). In addition to the group codes described here, those listed in and can also be present. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "DIMENSION","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a2b.htm"}]},
{"title":"Radial and Diameter Dimension Group Codes",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a21.htm",
"description":"The following group codes apply to radial and diameter dimensions. In addition to the group codes described here, those listed in and can also be present. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "DIMENSION","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a2b.htm"}]},
{"title":"Angular Dimension Group Codes",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a1d.htm",
"description":"The following group codes apply to angular dimensions. In addition to the group codes described here, those listed in and can also be present. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "DIMENSION","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a2b.htm"}]},
{"title":"Ordinate Dimension Group Codes",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a19.htm",
"description":"The following group codes apply to ordinate dimensions. In addition to the group codes described here, those listed in and can also be present. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "DIMENSION","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a2b.htm"}]},
{"title":"Dimension Style Overrides",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a16.htm",
"description":"Dimension style overrides can be applied to dimension, leader, and tolerance entities. Any overrides applied to these entities are stored in the entity as xdata. The overridden dimension variable group codes and the related values are contained within group 1002 control strings. The following example shows the xdata of a dimension entity where the DIMTOL and DIMCLRE variables have been overridden.",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "DIMENSION","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a2b.htm"}]},
{"title":"ELLIPSE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a15.htm",
"description":"The following group codes apply to ellipse entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"HATCH",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a13.htm",
"description":"The following group codes apply to hatch and MPolygon entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"Boundary Path Data",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a11.htm",
"description":"The boundary of each hatch object is defined by a path (or loop) that consists of one or more segments. Path segment data varies depending on the entity type (or types) that make up the path. Each path segment is defined by its own set of group codes. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "HATCH","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a13.htm"}]},
{"title":"Pattern Data",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a0a.htm",
"description":"The following pattern data codes repeat for each pattern definition line. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "HATCH","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a13.htm"}]},
{"title":"HELIX",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a08.htm",
"description":"The following group codes apply to helix entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"IMAGE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a06.htm",
"description":"The following group codes apply to image entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"INSERT",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a04.htm",
"description":"The following group codes apply to insert (block reference) entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"LEADER",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a02.htm",
"description":"The following group codes apply to leader entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"LIGHT",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7a00.htm",
"description":"The following group codes apply to light entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"LINE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79fe.htm",
"description":"The following group codes apply to line entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"LWPOLYLINE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79fc.htm",
"description":"The following group codes apply to lwpolyline entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"MESH",
"href":"./filesDXF/WS1a9193826455f5ff211a40be11dcc57291cfca.htm",
"description":"The following group codes apply to the mesh entity. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"MLINE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79fa.htm",
"description":"The following group codes apply to mline entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"MLEADERSTYLE",
"href":"./filesDXF/WS1a9193826455f5ffc751fd10f4618e369-5bdf.htm",
"description":"The following group codes apply to mleaderstyle entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"MLEADER",
"href":"./filesDXF/WS1a9193826455f5ffc751fd10f4618e369-5bd9.htm",
"description":"MLeader entity definitions consist of group codes that are common to all MLeader types, followed by codes specific to the type.",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"Common MLeader Group Codes",
"href":"./filesDXF/WS1a9193826455f5ffc751fd10f4618e369-5b2f.htm",
"description":"The following group codes apply to all mleaderstyle entity types. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "MLEADER","href":"./filesDXF/WS1a9193826455f5ffc751fd10f4618e369-5bd9.htm"}]},
{"title":"MLeader Context Data Group Codes",
"href":"./filesDXF/WS1a9193826455f5ffc751fd10f4618e369-5b2b.htm",
"description":"The following group codes apply to all mleader entity types’ context data. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "MLEADER","href":"./filesDXF/WS1a9193826455f5ffc751fd10f4618e369-5bd9.htm"}]},
{"title":"MLeader Leader Node Group Codes",
"href":"./filesDXF/WS1a9193826455f5ffc751fd10f4618e369-5b28.htm",
"description":"The following group codes apply to all mleader entity types’ leader node. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "MLEADER","href":"./filesDXF/WS1a9193826455f5ffc751fd10f4618e369-5bd9.htm"}]},
{"title":"MLeader Leader Line Group Codes",
"href":"./filesDXF/WS1a9193826455f5ffc751fd10f4618e369-5b24.htm",
"description":"The following group codes apply to all mleader entity types’ leader line. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "MLEADER","href":"./filesDXF/WS1a9193826455f5ffc751fd10f4618e369-5bd9.htm"}]},
{"title":"MTEXT",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79f8.htm",
"description":"The following group codes apply to mtext entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"OLEFRAME",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79f6.htm",
"description":"The following group codes apply to oleframe entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"OLE2FRAME",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79f4.htm",
"description":"The following group codes apply to ole2frame entities. This information is read-only. During OPEN, the values are ignored because they are part of the OLE binary object, and are obtained by access functions. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"POINT",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79f2.htm",
"description":"The following group codes apply to point entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"POLYLINE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79f0.htm",
"description":"The following group codes apply to polyline entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"Polyface Meshes",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79ee.htm",
"description":"A polyface mesh is represented in DXF as a variant of a polyline entity. The polyline header is identified as introducing a polyface mesh by the presence of the 64 bit in the polyline flags (70) group. The 71 group specifies the number of vertices in the mesh, and the 72 group specifies the number of faces. Although these counts are correct for all meshes created with the PFACE command, applications are not required to place correct values in these fields. Following the polyline header is a sequence of vertex entities that specify the vertex coordinates, followed by faces that compose the mesh.",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "POLYLINE","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79f0.htm"}]},
{"title":"RAY",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79ed.htm",
"description":"The following group codes apply to ray entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"REGION",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79eb.htm",
"description":"The following group codes apply to region entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"SECTION",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79e9.htm",
"description":"The following group codes apply to section entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"SEQEND",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79e7.htm",
"description":"The following group codes apply to seqend entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"SHAPE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79e5.htm",
"description":"The following group codes apply to shape entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"SOLID",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79e3.htm",
"description":"The following group codes apply to solid entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"SPLINE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79e1.htm",
"description":"The following group codes apply to spline entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"SUN",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79df.htm",
"description":"The following group codes apply to the sun entity. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"SURFACE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79dd.htm",
"description":"Surface entity definitions consist of group codes that are common to all surface types, followed by codes specific to the type.",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"Extruded Surface",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79db.htm",
"description":"The following group codes apply to extruded surfaces. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "SURFACE","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79dd.htm"}]},
{"title":"Lofted Surface",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79d9.htm",
"description":"The following group codes apply to lofted surfaces. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "SURFACE","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79dd.htm"}]},
{"title":"Revolved Surface",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79d7.htm",
"description":"The following group codes apply to revolved surfaces. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "SURFACE","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79dd.htm"}]},
{"title":"Swept Surface",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79d5.htm",
"description":"The following group codes apply to swept surfaces. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"},{"title": "SURFACE","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79dd.htm"}]},
{"title":"TABLE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79d3.htm",
"description":"The following group codes apply to table entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"TEXT",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79d1.htm",
"description":"The following group codes apply to text entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"TOLERANCE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79ce.htm",
"description":"The following group codes apply to tolerance entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"TRACE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79cc.htm",
"description":"The following group codes apply to trace entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"UNDERLAY",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79ca.htm",
"description":"The following group codes apply to underlays. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"VERTEX",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79c8.htm",
"description":"The following group codes apply to vertex entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"VIEWPORT",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79c6.htm",
"description":"The following group codes apply to viewport entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"WIPEOUT",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79c4.htm",
"description":"The following group codes apply to wipeout entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"XLINE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79c2.htm",
"description":"The following group codes apply to xline entities. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "ENTITIES Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5df0.htm"}]},
{"title":"OBJECTS Section",
"href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm",
"description":"This chapter presents the group codes that apply to nongraphical objects. These codes are found in the OBJECTS section of a DXF™ file and are used by AutoLISP® and ObjectARX® applications in entity definition lists.",
"ancestors":[]},
{"title":"OBJECT Section Group Codes",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79c0.htm",
"description":"Objects are similar to entities, except that they have no graphical or geometric meaning. All objects that are not entities or symbol table records or symbol tables are stored in this section. This section represents a homogeneous heap of objects with topological ordering of objects by ownership, such that the owners always appear before the objects they own.",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"Object Ownership",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79bf.htm",
"description":"The root owner of most objects appearing in the OBJECTS section is the named object dictionary, which is, therefore, always the first object that appears in this section. Objects that are not owned by the named object dictionary are owned by other entities, objects, or symbol table entries. Objects in this section may be defined by AutoCAD® or by applications with access to ObjectARX® API. The DXF names of application-defined object types should always be associated with a class name in the CLASS section of the DXF file, or else the object record cannot be bound to the application that will interpret it.",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"},{"title": "OBJECT Section Group Codes","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79c0.htm"}]},
{"title":"Common Group Codes for Objects",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79be.htm",
"description":"The following table shows group codes that apply to virtually all nongraphical objects. When you refer to a table of group codes by object type, a list of codes associated with a specific object, keep in mind that the codes shown here can also be present. Some of the group codes are included with an object only if the object has nondefault values for those group code properties. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"ACAD_PROXY_OBJECT",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79bc.htm",
"description":"The following group codes apply to ACAD_PROXY_OBJECT objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"ACDBDICTIONARYWDFLT",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79ba.htm",
"description":"The following group codes are used by ACDBDICTIONARYWDFLT objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"ACDBPLACEHOLDER",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79b8.htm",
"description":"The following group codes are used by the ACDBPLACEHOLDER objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"DATATABLE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79b6.htm",
"description":"The following group codes are used by the DATATABLE objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"DICTIONARY",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79b4.htm",
"description":"The following group codes are used by DICTIONARY objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"DICTIONARYVAR",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79b2.htm",
"description":"The following group codes are used by DICTIONARYVAR objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"DIMASSOC",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79b0.htm",
"description":"The following group codes are used by DIMASSOC objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"FIELD",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79ae.htm",
"description":"The following group codes are used by FIELD objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"GEODATA",
"href":"./filesDXF/WS73099cc142f4875535a241551166ac8792f-963.htm",
"description":"The following group codes are used by GEODATA objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"GROUP",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79ac.htm",
"description":"The following group codes are used by GROUP objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"IDBUFFER",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79aa.htm",
"description":"The following group codes are used by IDBUFFER objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"IMAGEDEF",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79a8.htm",
"description":"The following group codes are used by IMAGEDEF objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"IMAGEDEF_REACTOR",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79a6.htm",
"description":"The following group codes are used by IMAGEDEF_REACTOR objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"LAYER_INDEX",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79a4.htm",
"description":"The following group codes are used by LAYER_INDEX objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"LAYER_FILTER",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79a2.htm",
"description":"The following group codes are used by LAYER_FILTER objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"LAYOUT",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-79a0.htm",
"description":"The following group codes are used by LAYOUT objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"LIGHTLIST",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-799e.htm",
"description":"The following group codes are used by LIGHTLIST objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"MATERIAL",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-799c.htm",
"description":"The following group codes are used by MATERIAL objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"MLINESTYLE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-799a.htm",
"description":"The following group codes are used by MLINESTYLE objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"OBJECT_PTR",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7998.htm",
"description":"The following group codes are used by OBJECT_PTR objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"PLOTSETTINGS",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7996.htm",
"description":"The following group codes are used by PLOTSETTINGS objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"RASTERVARIABLES",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7994.htm",
"description":"The following group codes are used by RASTERVARIABLES objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"RENDER",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7992.htm",
"description":"Render related group codes.",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"RENDERENVIRONMENT",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7991.htm",
"description":"The following group codes are used by RENDERENVIRONMENT objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"},{"title": "RENDER","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7992.htm"}]},
{"title":"MENTALRAYRENDERSETTINGS",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-798f.htm",
"description":"The following group codes are used by MENTALRAYRENDERSETTINGS objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"},{"title": "RENDER","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7992.htm"}]},
{"title":"RENDERGLOBAL",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-798d.htm",
"description":"The following group codes are used by RENDERGLOBAL objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"},{"title": "RENDER","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7992.htm"}]},
{"title":"SECTION",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-798b.htm",
"description":"Section manager and section settings group codes.",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"Section Manager",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-798a.htm",
"description":"The following group codes apply to SECTIONMANAGER objects. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"},{"title": "SECTION","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-798b.htm"}]},
{"title":"Section Settings",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7988.htm",
"description":"The following group codes apply to SECTIONSETTINGS objects. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"},{"title": "SECTION","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-798b.htm"}]},
{"title":"Section Type Settings",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7986.htm",
"description":"The following group codes apply to Section Type settings. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"},{"title": "SECTION","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-798b.htm"}]},
{"title":"Section Geometry Settings",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7984.htm",
"description":"The following group codes apply to Section geometry settings. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"},{"title": "SECTION","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-798b.htm"}]},
{"title":"SPATIAL_INDEX",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7982.htm",
"description":"The following group codes are used by SPATIAL_INDEX objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"SPATIAL_FILTER",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7980.htm",
"description":"The following group codes are used by SPATIAL_FILTER objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"SORTENTSTABLE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-797e.htm",
"description":"The following group codes are used by SORTENTSTABLE objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"TABLESTYLE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-797a.htm",
"description":"The following group codes are used by TABLESTYLE objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"UNDERLAYDEFINITION",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7978.htm",
"description":"The following group codes apply to UNDERLAYDEFINITION symbol table entries. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"VISUALSTYLE",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7976.htm",
"description":"The following group codes apply to VISUALSTYLE objects. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"VBA_PROJECT",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7974.htm",
"description":"The following group codes are used by VBA_PROJECT objects. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"WIPEOUTVARIABLES",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7972.htm",
"description":"The following group codes are used by WIPEOUTVARIABLES objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"XRECORD",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7970.htm",
"description":"The following group codes are common to all xrecord objects. In addition to the group codes described here, see . For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "OBJECTS Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d8d.htm"}]},
{"title":"THUMBNAILIMAGE Section",
"href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d53.htm",
"description":"This chapter presents the group codes that are found in the THUMBNAILIMAGE section of a DXF™ file. This section exists only if a preview image has been saved with the DXF file.",
"ancestors":[]},
{"title":"THUMBNAILIMAGE Section Group Codes",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-796e.htm",
"description":"The following group codes are found in the THUMBNAILIMAGE section. For information about abbreviations and formatting used in this table, see .",
"ancestors":[{"title": "THUMBNAILIMAGE Section","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d53.htm"}]},
{"title":"Drawing Interchange File Formats",
"href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm",
"description":"This appendix describes the various file formats AutoCAD® uses to interchange drawing data with other applications. The formats presented are Drawing Interchange File (DXF™), binary DXF, Slide (SLD), and the Slide Library (SLB) file formats.",
"ancestors":[]},
{"title":"ASCII DXF Files",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-796c.htm",
"description":"This section describes the format of ASCII DXF files. It contains information that is needed only if you write your own programs to process DXF files or work with entity information obtained by AutoLISP® and ObjectARX® applications.",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"}]},
{"title":"General DXF File Structure",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-796b.htm",
"description":"Essentially, a DXF file is composed of pairs of codes and associated values. The codes, known as group codes, indicate the type of value that follows. Using these group code and value pairs, a DXF file is organized into sections composed of records, which are composed of a group code and a data item. Each group code and value are on their own line in the DXF file.",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"},{"title": "ASCII DXF Files","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-796c.htm"}]},
{"title":"Group Codes in DXF Files",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7969.htm",
"description":"Group codes and the associated values define a specific aspect of an object or entity. The line immediately following the group code is the associated value. This value can be a string, an integer, or a floating-point value, such as the X coordinate of a point. The lines following the second line of the group, if any, are determined by the group definition and the data associated with the group.",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"},{"title": "ASCII DXF Files","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-796c.htm"}]},
{"title":"ASCII Control Characters in DXF Files",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7968.htm",
"description":"SAVEAS handles ASCII control characters in text strings by expanding the character into a caret (^) followed by the appropriate letter. For example, an ASCII Control-G (BEL, decimal code 7) is written as ^G. If the text itself contains a caret character, it is expanded to caret, space (^). OPEN and INSERT perform the complementary conversion.",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"},{"title": "ASCII DXF Files","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-796c.htm"},{"title": "Group Codes in DXF Files","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7969.htm"}]},
{"title":"Header Group Codes in DXF Files",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7967.htm",
"description":"Applications can retrieve the values of these variables with the AutoLISP getvar function.",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"},{"title": "ASCII DXF Files","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-796c.htm"}]},
{"title":"Class Group Codes in DXF Files",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7965.htm",
"description":"The following is an example of the CLASSES section of a DXF file:",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"},{"title": "ASCII DXF Files","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-796c.htm"}]},
{"title":"Symbol Table Group Codes in DXF Files",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7963.htm",
"description":"The following is an example of the TABLES section of a DXF file.",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"},{"title": "ASCII DXF Files","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-796c.htm"}]},
{"title":"Symbol Table Example",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7961.htm",
"description":"This DXF sequence represents three full objects: the symbol table itself plus two entries.",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"},{"title": "ASCII DXF Files","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-796c.htm"},{"title": "Symbol Table Group Codes in DXF Files","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7963.htm"}]},
{"title":"Blocks Group Codes in DXF Files",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-795f.htm",
"description":"The following is an example of the BLOCKS section of a DXF file:",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"},{"title": "ASCII DXF Files","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-796c.htm"}]},
{"title":"Entity Group Codes in DXF Files",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-795d.htm",
"description":"The following is an example of the ENTITIES section of a DXF file:",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"},{"title": "ASCII DXF Files","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-796c.htm"}]},
{"title":"Object Group Codes in DXF Files",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-795b.htm",
"description":"The following is an example of the OBJECTS section of a DXF file:",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"},{"title": "ASCII DXF Files","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-796c.htm"}]},
{"title":"Writing a DXF Interface Program",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7959.htm",
"description":"Writing a program that communicates with AutoCAD by means of the DXF file appears more difficult than it actually is. The DXF format makes it easy to ignore information you don\'t need, while reading the information you do need.",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"},{"title": "ASCII DXF Files","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-796c.htm"}]},
{"title":"Reading a DXF File",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7958.htm",
"description":"The following example is a simple Visual Basic 6 program that reads a DXF file and extracts specific codes and values from a given object in a given section.",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"},{"title": "ASCII DXF Files","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-796c.htm"},{"title": "Writing a DXF Interface Program","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7959.htm"}]},
{"title":"Writing a DXF File",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7957.htm",
"description":"Writing a program that creates a DXF file can be more difficult than one that reads a DXF file, because you must maintain consistency within the drawing in order for AutoCAD to find the file acceptable. AutoCAD lets you omit many items in a DXF file and still obtain a usable drawing.",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"},{"title": "ASCII DXF Files","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-796c.htm"},{"title": "Writing a DXF Interface Program","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7959.htm"}]},
{"title":"Binary DXF Files",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7955.htm",
"description":"The ASCII DXF file format is a complete representation of an AutoCAD drawing in an ASCII text form, and is easily processed by other programs. In addition, AutoCAD can produce or read a binary form of the full DXF file and accept limited input in another binary file format.",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"}]},
{"title":"Slide Files",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7953.htm",
"description":"AutoCAD slide files are screen images written by the MSLIDE command and read by the VSLIDE command. This section describes the format of slide files for the benefit of developers who wish to incorporate support for slides into their programs.",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"}]},
{"title":"Old Slide Header",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7950.htm",
"description":"The slide format described in the previous section is produced by AutoCAD Release 9 and later, and is portable among all computers running AutoCAD Release 9 or later. Previous versions of AutoCAD (as well as AutoShade® 1.0 and AutoSketch® 1.02) produce slides with a somewhat different header, as shown in the following table.",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"},{"title": "Slide Files","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7953.htm"}]},
{"title":"Slide Library Files",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-794e.htm",
"description":"This section describes the format of AutoCAD slide libraries (Release 9 and later) for the benefit of developers who wish to incorporate support for slide libraries into their programs.",
"ancestors":[{"title": "Drawing Interchange File Formats","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d50.htm"}]},
{"title":"Advanced DXF Issues",
"href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d05.htm",
"description":"This appendix discusses the advanced concepts related to DXF™ group codes.",
"ancestors":[]},
{"title":"Database Objects",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-794d.htm",
"description":"AutoCAD® drawings consist largely of structured containers for database objects. Database objects each have the following features:",
"ancestors":[{"title": "Advanced DXF Issues","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d05.htm"}]},
{"title":"Persistent Inter-Object Reference Handles",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-794b.htm",
"description":"A set of group code ranges permits objects to directly specify references to other objects within the same drawing/DXF file. Four ranges are provided for the four types of reference handles that you can specify:",
"ancestors":[{"title": "Advanced DXF Issues","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d05.htm"}]},
{"title":"Pointer and Ownership References",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7949.htm",
"description":"A pointer is a reference that indicates usage, but not possession or responsibility, for another object. A pointer reference means that the object uses the other object in some way, and shares access to it.",
"ancestors":[{"title": "Advanced DXF Issues","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d05.htm"},{"title": "Persistent Inter-Object Reference Handles","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-794b.htm"}]},
{"title":"Hard and Soft References",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7948.htm",
"description":"Hard references, whether they are pointer or owner, protect an object from being purged. Soft references do not.",
"ancestors":[{"title": "Advanced DXF Issues","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d05.htm"},{"title": "Persistent Inter-Object Reference Handles","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-794b.htm"}]},
{"title":"Arbitrary Handles",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7947.htm",
"description":"Arbitrary handles are distinct in that they are not translated to session-persistent identifiers internally, or to entity names in AutoLISP, and so on. They are stored as handles. When handle values are translated in drawing-merge operations, arbitrary handles are ignored.",
"ancestors":[{"title": "Advanced DXF Issues","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d05.htm"},{"title": "Persistent Inter-Object Reference Handles","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-794b.htm"}]},
{"title":"1005 Group Codes",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7946.htm",
"description":"1005 xdata group codes have the same behavior and semantics as soft pointers, which means that they are translated whenever the host object is merged into a different drawing. However, 1005 items are not translated to session-persistent identifiers or internal entity names in AutoLISP and ObjectARX. They are stored as handles.",
"ancestors":[{"title": "Advanced DXF Issues","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d05.htm"},{"title": "Persistent Inter-Object Reference Handles","href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-794b.htm"}]},
{"title":"Subclass Markers",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7945.htm",
"description":"When filing a stream of group data, a single object may be composed of several filer members, one for each level of inheritance where filing is done. Since derived classes and levels of inheritance can evolve separately, the data of each class filer member must be segregated from other members. This is achieved using subclass markers.",
"ancestors":[{"title": "Advanced DXF Issues","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d05.htm"}]},
{"title":"Extension Dictionary and Persistent Reactors",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7944.htm",
"description":"The extension dictionary is an optional sequence that stores the handle of a dictionary object that belongs to the current object, which in turn may contain entries. This facility allows attachment of arbitrary database objects to any database object. Any object or entity may have this section.",
"ancestors":[{"title": "Advanced DXF Issues","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d05.htm"}]},
{"title":"Extended Data",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7943.htm",
"description":"Extended data (xdata) is created by AutoLISP or ObjectARX applications. If an entity contains extended data, it follows the entity\'s normal definition data. The group codes 1000 through 1071 describe extended data. The following is an example of an entity containing extended data in DXF format.",
"ancestors":[{"title": "Advanced DXF Issues","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d05.htm"}]},
{"title":"Object Coordinate Systems (OCS)",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-7941.htm",
"description":"To save space in the drawing database (and in the DXF file), the points associated with each entity are expressed in terms of the entity\'s own object coordinate system (OCS). With OCS, the only additional information needed to describe the entity\'s position in 3D space are the 3D vector describing the Z axis of the OCS and the elevation value.",
"ancestors":[{"title": "Advanced DXF Issues","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d05.htm"}]},
{"title":"Arbitrary Axis Algorithm",
"href":"./filesDXF/WS1a9193826455f5ff18cb41610ec0a2e719-793d.htm",
"description":"The arbitrary axis algorithm is used by AutoCAD internally to implement the arbitrary but consistent generation of object coordinate systems for all entities that use object coordinates.",
"ancestors":[{"title": "Advanced DXF Issues","href":"./filesDXF/WSfacf1429558a55de185c428100849a0ab7-5d05.htm"}]},
]);
top.HlpSys.search.data.registerSearchProvider(searchResultProvider);
// SIG // Begin signature block
// SIG // MIIMzQYJKoZIhvcNAQcCoIIMvjCCDLoCAQExDjAMBggq
// SIG // hkiG9w0CBQUAMGYGCisGAQQBgjcCAQSgWDBWMDIGCisG
// SIG // AQQBgjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIB
// SIG // AAIBAAIBAAIBAAIBADAgMAwGCCqGSIb3DQIFBQAEEM5j
// SIG // zOlS+DKt1ukVx2m7TPWgggoPMIIE/DCCBGWgAwIBAgIQ
// SIG // ZVIm4bIuGOFZDymFrCLnXDANBgkqhkiG9w0BAQUFADBf
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xNzA1BgNVBAsTLkNsYXNzIDMgUHVibGljIFBy
// SIG // aW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcN
// SIG // MDkwNTIxMDAwMDAwWhcNMTkwNTIwMjM1OTU5WjCBtjEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3
// SIG // b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0
// SIG // cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykwOTEw
// SIG // MC4GA1UEAxMnVmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNp
// SIG // Z25pbmcgMjAwOS0yIENBMIIBIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAQ8AMIIBCgKCAQEAvmcdtGCqEElvVhd8Zslehg3V
// SIG // 8ayncYOOi4n4iASJFQa6LYQhleTRnFBM+9IivdrysjU7
// SIG // Ho/DCfv8Ey5av4l8PTslHvbzWHuc9AG1xgq4gM6+J3Rh
// SIG // ZydNauXsgWFYeaPgFxASFSew4U00fytHIES53mYkZorN
// SIG // T7ofxTjIVJDhcvYZZnVquUlozzh5DaowqNssYEie16oU
// SIG // AamD1ziRMDkTlgM6fEBUtq3gLxuD3KgRUj4Cs9cr/SG2
// SIG // p1yjDwupphBQDjQuTafOyV4l1Iy88258KbwBXfwxh1rV
// SIG // jIVnWIgZoL818OoroyHnkPaD5ajtYHhee2CD/VcLXUEN
// SIG // Y1Rg1kMh7wIDAQABo4IB2zCCAdcwEgYDVR0TAQH/BAgw
// SIG // BgEB/wIBADBwBgNVHSAEaTBnMGUGC2CGSAGG+EUBBxcD
// SIG // MFYwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9jcHMwKgYIKwYBBQUHAgIwHhocaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTAOBgNVHQ8BAf8E
// SIG // BAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcwVRYJ
// SIG // aW1hZ2UvZ2lmMCEwHzAHBgUrDgMCGgQUj+XTGoasjY5r
// SIG // w8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVyaXNp
// SIG // Z24uY29tL3ZzbG9nby5naWYwHQYDVR0lBBYwFAYIKwYB
// SIG // BQUHAwIGCCsGAQUFBwMDMDQGCCsGAQUFBwEBBCgwJjAk
// SIG // BggrBgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24u
// SIG // Y29tMDEGA1UdHwQqMCgwJqAkoCKGIGh0dHA6Ly9jcmwu
// SIG // dmVyaXNpZ24uY29tL3BjYTMuY3JsMCkGA1UdEQQiMCCk
// SIG // HjAcMRowGAYDVQQDExFDbGFzczNDQTIwNDgtMS01NTAd
// SIG // BgNVHQ4EFgQUl9BrqCZwyKE/lB8ILcQ1m6ShHvIwDQYJ
// SIG // KoZIhvcNAQEFBQADgYEAiwPA3ZTYQaJhabAVqHjHMMaQ
// SIG // PH5C9yS25INzFwR/BBCcoeL6gS/rwMpE53LgULZVECCD
// SIG // bpaS5JpRarQ3MdylLeuMAMcdT+dNMrqF+E6++mdVZfBq
// SIG // vnrKZDgaEBB4RXYx84Z6Aw9gwrNdnfaLZnaCG1nhg+W9
// SIG // SaU4VuXeQXcOWA8wggULMIID86ADAgECAhAjTaBL0kKF
// SIG // PErLmuhhwhm7MA0GCSqGSIb3DQEBBQUAMIG2MQswCQYD
// SIG // VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4x
// SIG // HzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsx
// SIG // OzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhIChjKTA5MTAwLgYD
// SIG // VQQDEydWZXJpU2lnbiBDbGFzcyAzIENvZGUgU2lnbmlu
// SIG // ZyAyMDA5LTIgQ0EwHhcNMDkwODI3MDAwMDAwWhcNMTIw
// SIG // OTIwMjM1OTU5WjCByDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCkNhbGlmb3JuaWExEzARBgNVBAcTClNhbiBSYWZh
// SIG // ZWwxFjAUBgNVBAoUDUF1dG9kZXNrLCBJbmMxPjA8BgNV
// SIG // BAsTNURpZ2l0YWwgSUQgQ2xhc3MgMyAtIE1pY3Jvc29m
// SIG // dCBTb2Z0d2FyZSBWYWxpZGF0aW9uIHYyMR8wHQYDVQQL
// SIG // FBZEZXNpZ24gU29sdXRpb25zIEdyb3VwMRYwFAYDVQQD
// SIG // FA1BdXRvZGVzaywgSW5jMIGfMA0GCSqGSIb3DQEBAQUA
// SIG // A4GNADCBiQKBgQC1R1YKdvQF2Rj4+knWfj81afUtVyep
// SIG // GF2P4tcYD53qlYmYi9t9Csc6PMWlUZhMGbOceQKYcBjc
// SIG // mWvyghJnoaEQ6796ZcsLD0pMH2R4SpV/SjxiQ280beig
// SIG // NerJS5X+ftOMCs1qSQ1LXlRFEohaewkNWsIp/+f1Y0vE
// SIG // dGzggnEKOQIDAQABo4IBgzCCAX8wCQYDVR0TBAIwADAO
// SIG // BgNVHQ8BAf8EBAMCB4AwRAYDVR0fBD0wOzA5oDegNYYz
// SIG // aHR0cDovL2NzYzMtMjAwOS0yLWNybC52ZXJpc2lnbi5j
// SIG // b20vQ1NDMy0yMDA5LTIuY3JsMEQGA1UdIAQ9MDswOQYL
// SIG // YIZIAYb4RQEHFwMwKjAoBggrBgEFBQcCARYcaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzB1BggrBgEFBQcBAQRpMGcwJAYIKwYB
// SIG // BQUHMAGGGGh0dHA6Ly9vY3NwLnZlcmlzaWduLmNvbTA/
// SIG // BggrBgEFBQcwAoYzaHR0cDovL2NzYzMtMjAwOS0yLWFp
// SIG // YS52ZXJpc2lnbi5jb20vQ1NDMy0yMDA5LTIuY2VyMB8G
// SIG // A1UdIwQYMBaAFJfQa6gmcMihP5QfCC3ENZukoR7yMBEG
// SIG // CWCGSAGG+EIBAQQEAwIEEDAWBgorBgEEAYI3AgEbBAgw
// SIG // BgEBAAEB/zANBgkqhkiG9w0BAQUFAAOCAQEAIfxkh8Fd
// SIG // IHK+qtTf+9Eq5fjkk5gMMTQCOa+2aR7mqDzLfIFRGQzr
// SIG // tcc5/izsb/wPLUwdw1cRpnxO8/qLA2Ol+b99FONTOyyc
// SIG // Y8unwviYhdEjuFmqHkyC5MUYroZEjvTObFkkgN98Y48h
// SIG // C+mG2hdlVKXR0zr9r5q/rmmivVWbojvcYKHoW31O5OcM
// SIG // PsrWuOD305Ygmpck/91iopE3UN4tfeWYhzNj1F6Ai4Xa
// SIG // 5KiaMcs3zmoZ+6SePyI2YUgtff6yvy/rk8KVT41KGD2h
// SIG // fC+QrtVSkoDWP/MDtLjbTPCWElC1NWSEKowRI8t2x594
// SIG // Skjnzu/W5Lh97ixircOuM4IvBzGCAigwggIkAgEBMIHL
// SIG // MIG2MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNp
// SIG // Z24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0
// SIG // IE5ldHdvcmsxOzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBh
// SIG // dCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20vcnBhIChj
// SIG // KTA5MTAwLgYDVQQDEydWZXJpU2lnbiBDbGFzcyAzIENv
// SIG // ZGUgU2lnbmluZyAyMDA5LTIgQ0ECECNNoEvSQoU8Ssua
// SIG // 6GHCGbswDAYIKoZIhvcNAgUFAKCBsDAZBgkqhkiG9w0B
// SIG // CQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
// SIG // DAYKKwYBBAGCNwIBFTAfBgkqhkiG9w0BCQQxEgQQvTot
// SIG // R3S3Csy1zlNcq5wsWjBUBgorBgEEAYI3AgEMMUYwRKAm
// SIG // gCQAQQB1AHQAbwBkAGUAcwBrACAAQwBvAG0AcABvAG4A
// SIG // ZQBuAHShGoAYaHR0cDovL3d3dy5hdXRvZGVzay5jb20g
// SIG // MA0GCSqGSIb3DQEBAQUABIGAWUFYdWoXRFBVeaXuwmZK
// SIG // Os6cA9UI9aOnElB2+8kl5/9fOl0+2begMyl8whNQmhKY
// SIG // RWMVWqT68xtbwpXirtAO4RiYGwDGa10cD+b8mwIPGaj+
// SIG // 6ab4hBUPVa+VuG/X/uh2Ezc3HOOFvkgv15aW2Rk2bi+2
// SIG // U+o8ovw+J8U4vs/+Noc=
// SIG // End signature block
